clear all
clc
close all


%% Create Data

load AALabData

Y=Action;
Row=row;
features=FeaturesAct;
featGame=FeaturesMatrix;
clear FeaturesMatrix

load AANewData

featGame=[featGame; FeaturesMatrix];
features=[features; FeaturesAct];

Y=[Y;modal'];
Row=[Row;row'];

clear modal row

load AAMTData

s=length(row);
act=zeros(s,1);
for i=1:s
    act(i)=modal{i}(1);
end

featGame=[featGame; FeaturesMatrix];
features=[features; FeaturesAct];

%featGame(:,[33,34])=[];
%DescriptionMatrix([33,34])=[];

Y=[Y;act];
Row=[Row;row];

n=length(Y);

%% Evaluate

ind=[3,15,27];
FeatParetoDomNE=features(:,ind);

Q=10;
acc=zeros(1,Q);
stderr=zeros(1,Q);
for q=1:Q
    
    paretonepred=zeros(n,1);
    for i=1:n
        if sum(FeatParetoDomNE(i,:))>0
            paretonepred(i)=find(FeatParetoDomNE(i,:));
        else
            paretonepred(i)=randi(3);
        end
    end
    
    testalpha=0.01:0.05:1;
    r=length(testalpha);
    
    accurate=zeros(25,1);
    K=10;
    c = cvpartition(n,'KFold',K);
    bestalpha=zeros(1,K);
    for k=1:K
        
        % Training Data
        
        train=find(c.training(k));
        trainPNE=paretonepred(train);
        trainY=Y(train,:);
        trainRow=Row(train);
        
        Acc=zeros(1,r);
        m=length(train);
        for i=1:r
            alpha=testalpha(i);
            lev1R=zeros(1,m);
            accurate=zeros(1,m);
            for h=1:m
                R=trainRow{h}.^alpha;
                [~,lev1R(h)]=max(sum(R,2));
                accurate(h)=logical(trainY(h)==lev1R(h));
            end
            Acc(i)=mean(accurate);
            clear lev1R accurate
        end
        [~,best]=max(Acc);
        bestalpha(k)=testalpha(best);
        
        trainlev1=zeros(m,1);
        for i=1:m
            R=trainRow{i}.^bestalpha(k);
            [~,trainlev1(i)]=max(sum(R,2));
        end
        
        trainNew=featGame(train,:);
        
        accpne{k}=double(logical(trainPNE==trainY));
        acclev1{k}=double((logical(trainY==trainlev1)));
        
        treemodelpne{k}=fitrtree(trainNew,accpne{k},'MaxNumSplits',2,'PredictorNames',DescriptionMatrix);
        treemodellev1{k}=fitrtree(trainNew,acclev1{k},'MaxNumSplits',2,'PredictorNames',DescriptionMatrix);
        
        % Test Data
        
        test=find(c.test(k));
        testY{k}=Y(test,:);
        testRow=Row(test);
        testNew=featGame(test,:);
        
        pnepredicttest=paretonepred(test);
        
        s=length(test);
        testlev1=zeros(s,1);
        for i=1:s
            R=testRow{i}.^bestalpha(k);
            [~,testlev1(i)]=max(sum(R,2));
        end
        
        predictpneerr{k}=predict(treemodelpne{k},testNew);
        predictlev1err{k}=predict(treemodellev1{k},testNew);
        
        m=length(testY{k});
        for j=1:m
            if predictpneerr{k}(j)>predictlev1err{k}(j)
                prediction{k}(j)=pnepredicttest(j);
            else
                prediction{k}(j)=testlev1(j);
            end
        end
        accuracy(k)=length(find(prediction{k}'~=testY{k}))/length(prediction{k});
    end
    acc(q)=1-mean(accuracy);
    stderr(q)=sqrt(var(accuracy))/sqrt(K);
end

'Accuracy'
mean(acc)

'Standard Error'
mean(stderr)

%% View Trees

view(treemodelpne{1},'mode','graph')
view(treemodellev1{1},'mode','graph')
